#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gdk::EventButton
# =========================================================================== #
# require 'gtk_paradise/core_classes/event_button.rb'
# =========================================================================== #
module Gdk

class EventButton # === Gdk::EventButton

  # ========================================================================= #
  # === x_position?
  # ========================================================================= #
  def x_position?
    x
  end; alias x_coordinate? x_position? # === x_coordinate?

  # ========================================================================= #
  # === y_position?
  # ========================================================================= #
  def y_position?
    y
  end; alias y_coordinate? y_position? # === y_coordinate?

  # ========================================================================= #
  # === name?
  # ========================================================================= #
  def name?
    event_type.name
  end

  # ========================================================================= #
  # === mouse_button_double_click?
  #
  # Query whether the event is a double-click event, via the mouse button.
  #
  # Obviously you have to pass in an event-instance to this method.
  # ========================================================================= #
  def mouse_button_double_click?(event)
    # if ::Gtk.use_gtk2?
    #   event.event_type == Gdk::Event::BUTTON2_PRESS and
    #   event.button == 1
    event.event_type == Gdk::EventType::BUTTON2_PRESS and
    event.button == 1
  end

end; end

if __FILE__ == $PROGRAM_NAME
  require 'gtk_paradise/requires/require_the_default_gtk_version.rb'
end