#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/core_classes/expander.rb'
# Gtk.expander
# =========================================================================== #
module Gtk

class Expander # === Gtk::Expander

  require 'gtk_paradise/toplevel_methods/determine_which_gtk_version_is_in_use.rb'

  # ========================================================================= #
  # === attach_to_this_widget
  # ========================================================================= #
  unless Gtk.do_we_use_gtk4?
    alias attach_to_this_widget add
  end

  # ========================================================================= #
  # === do_expand
  # ========================================================================= #
  def do_expand
    self.expanded = true
  end; alias is_expanded do_expand # === is_expanded

  # ========================================================================= #
  # === do_collapse
  # ========================================================================= #
  def do_collapse
    self.expanded = false
  end

end

# =========================================================================== #
# === Gtk.expander
# =========================================================================== #
def self.expander
  ::Gtk::Expander.new
end

end