#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::FileChooserDialog
# =========================================================================== #
# require 'gtk_paradise/core_classes/file_chooser_dialog.rb'
# =========================================================================== #
module Gtk

class FileChooserDialog # === Gtk::FileChooserDialog

  alias add_directory      add_shortcut_folder # === add_directory
  alias add_this_directory add_shortcut_folder # === add_this_directory

  # ========================================================================= #
  # === do_show_hidden_files
  # ========================================================================= #
  def do_show_hidden_files
    self.show_hidden = true 
  end

  # ========================================================================= #
  # === cd_to
  # ========================================================================= #
  def cd_to(
      this_directory = '/tmp/'
    )
    if this_directory and File.directory?(this_directory)
      self.current_folder = this_directory
    end
  end

end; end