#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/core_classes/file_selection.rb'
# Gtk.file_selection
# =========================================================================== #
module Gtk

  require 'gtk_paradise/toplevel_methods/determine_which_gtk_version_is_in_use.rb'

  # ========================================================================= #
  # === Gtk.file_selection
  #
  # This method can be used to select a particular file, through the
  # main GTK dialog.
  # ========================================================================= #
  def self.file_selection(
      border_width    = 5,
      window_position = :mouse
    )
    # if do_we_use_gtk2?
    #   file_selection = ::Gtk::FileSelection.new('file selection dialog')
    #   window_position = ::Gtk::Window::POS_MOUSE
    file_selection = ::Gtk::FileChooserDialog.new(title: 'file selection dialog')
    file_selection.window_position = window_position

    file_selection.border_width = border_width
    return_value = file_selection.run # Run it here.
    success_or_failure = nil

    case return_value
    # ======================================================================= #
    # === ok-response
    # ======================================================================= #
    when ::Gtk::Dialog::RESPONSE_OK
      success_or_failure = :success
    # ======================================================================= #
    # === cancel-response
    # ======================================================================= #
    when ::Gtk::Dialog::RESPONSE_CANCEL
      success_or_failure = :failure
    end
    filename = file_selection.filename
    file_selection.destroy
    # ======================================================================= #
    # Return the filename here, and whether the operation was a success or
    # not. This will be in the form of an Array.
    # ======================================================================= #
    [ filename, success_or_failure ]
  end

end

if __FILE__ == $PROGRAM_NAME
  require 'gtk3'
  result = Gtk.file_selection
  pp result
end # gtkfileselectionexample