#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::Frame
# =========================================================================== #
# require 'gtk_paradise/core_classes/frame.rb'
# frame = Gtk::Frame.new; frame.make_bold
# =========================================================================== #
module Gtk

class Frame # === Gtk::Frame

  require 'gtk_paradise/toplevel_methods/determine_which_gtk_version_is_in_use.rb'

  # ========================================================================= #
  # === set_text
  # ========================================================================= #
  def set_text(i)
    set_label(i.to_s)
  end; alias set_title  set_text # === set_title
       alias set_header set_text # === set_header
       alias header=    set_text # === header=

  # ========================================================================= #
  # === add_this_widget
  #
  # This does not work for ruby-gtk4.
  # ========================================================================= #
  unless Gtk.do_we_use_gtk4?
    alias add_this_widget add
  end

  # ========================================================================= #
  # === use_etched_in_shadow
  # ========================================================================= #
  def use_etched_in_shadow(
      i = :etched_in # Default value for ruby-gtk3.
    )
    # if ::Gtk.use_gtk2?
    #   i = ::Gtk::SHADOW_ETCHED_IN
    # end
    set_shadow_type(i)
  end; alias etched_in_shadow use_etched_in_shadow # === etched_in_shadow

  # ========================================================================= #
  # === make_bold
  #
  # This method will make the label in the Gtk::Frame bold, aka thicker.
  #
  # Note that the label_widget in use has to respond to the method called
  # .make_bold(), as otherwise this code would fail.
  # ========================================================================= #
  def make_bold
    label_widget.make_bold if label_widget.respond_to? :make_bold
  end

  # ========================================================================= #
  # === set_markup
  #
  # This is a simpler wrapper used to specifically modify the
  # Gtk::Label that is carried inside of a Gtk::Frame.
  #
  # Note that the second argument for set_markup() is "mnemonic", which
  # defaults to false.
  # ========================================================================= #
  def set_markup(i, mnemonic = false)
    label_widget.set_markup(i, mnemonic)
  end

  # ========================================================================= #
  # === label_widget?
  # ========================================================================= #
  def label_widget?
    label_widget
  end

end

# =========================================================================== #
# === Gtk.frame
#
# Easier toplevel-method to instantiate a new Gtk::Frame instance.
# =========================================================================== #
def self.frame(
    optional_this_widget = nil
  )
  if optional_this_widget
    Gtk::Frame.new(optional_this_widget)
  else
    Gtk::Frame.new
  end
end; self.instance_eval { alias gtk_frame frame } # === Gtk.gtk_frame

end