#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/core_classes/hscale.rb'
# Gtk.hscale(0.0, 5.0, 0.1)
# =========================================================================== #
module Gtk

  require 'gtk_paradise/toplevel_methods/determine_which_gtk_version_is_in_use.rb'

  # ========================================================================= #
  # === Gtk.hscale
  #
  # A Gtk::Scale is a slider control used to select a numeric value.
  #
  # An example for Gtk::HScale follows next:
  #
  #   Gtk::HScale.new(0.0, 5.0, 0.1)
  #
  # This would mean that we will set a new scale that starts at 0.0, goes
  # up to 5.0, and goes in incremental steps of + or - 0.1.
  #
  # Note that in ruby-gtk3, HScale is now called like this:
  #
  #   Gtk::Scale.new(:horizontal, *args)
  #
  # The documentation for Gtk::Hscale can be found here:
  #
  #   https://ruby-gnome2.osdn.jp/hiki.cgi?cmd=view&p=Gtk%3A%3AHScale
  #
  # ========================================================================= #
  def self.hscale(
      optional_hash = {}
    )
    hscale = Gtk::Scale.new(:horizontal)
    # ======================================================================= #
    # === Handle Hashes first
    # ======================================================================= #
    if optional_hash.is_a? Hash
      # ===================================================================== #
      # === :n_digits
      #
      # Usage example:
      #
      #   Gtk.hscale( n_digits: 30 )
      #
      # ===================================================================== #
      if optional_hash.has_key? :n_digits
        hscale.set_digits(optional_hash.delete(:n_digits))
      end
    else # Else it is not a Hash, logically.
      hscale = Gtk::HScale.new(*optional_hash)
    end
    return hscale
  end

end