#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ListStore
#
# If you want to remove all rows from the given Gtk::ListStore then make
# use of the method called .clear().
# =========================================================================== #
# require 'gtk_paradise/core_classes/list_store.rb'
# =========================================================================== #
# API documentation can be found here:
#
#   https://lazka.github.io/pgi-docs/Gtk-3.0/classes/ListStore.html
#
# =========================================================================== #
module Gtk

class ListStore # === Gtk::ListStore

  # ========================================================================= #
  # === do_empty
  # ========================================================================= #
  alias do_empty clear

  # ========================================================================= #
  # === append_this_string
  # ========================================================================= #
  def append_this_string(i = 'Karl')
    iter = self.append
    set_value(iter, 0, i)
  end

  # ========================================================================= #
  # === attach_this_array
  #
  # This method should only be used for a simplifed array, aka only one
  # entry per line. We will only add a simple Array.
  #
  # Usage example:
  #
  #   .attach_this_array( %w( one two three four five ) )
  #
  # ========================================================================= #
  def attach_this_array(array)
    array.each { |entry|
      iter = self.append # self. is not needed, but I wanted it to be more explicit here.
      iter[0] = entry
    }
  end
  
  # ========================================================================= #
  # === Gtk::ListStore[]
  # ========================================================================= #
  def self.[](*i)
    new(i)
  end

end; end