#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::TextViewColumn
# =========================================================================== #
# require 'gtk_paradise/core_classes/tree_view_column.rb'
# =========================================================================== #
module Gtk

class TreeViewColumn # === Gtk::TextViewColumn

  # ========================================================================= #
  # === cell_renderers?
  #
  # If all goes well then this method will return an Array containing
  # Gtk::CellRendererText entries.
  #
  # Example output:
  #
  #   [#<Gtk::CellRendererText:0x55e3f70a3ad0 ptr=0x55e3f51274a0>]
  #
  # Note that this variant only works in ruby-gtk3.
  # ========================================================================= #
  def cell_renderers?
    cells
  end; alias renderers? cell_renderers? # === renderers?

  # ========================================================================= #
  # === allow_resizing
  # ========================================================================= #
  def allow_resizing
    set_resizable(true)
  end

  # ========================================================================= #
  # === sort_based_on
  #
  # This is a simplified-sort method.
  # ========================================================================= #
  def sort_based_on(id = 0)
    set_sort_column_id(id)
  end; alias sortable_based_on sort_based_on # === sortable_based_on
       alias sort_via          sort_based_on # === sort_via

  # ========================================================================= #
  # === center
  #
  # This method will center (aka "align to the middle") the content of
  # that tree-view-column.
  #
  # To center-align the first column you can try this:
  #
  #   .first_column?.center
  #
  # ========================================================================= #
  def center
    set_alignment(0.5)
  end; alias align_to_the_middle center # === align_to_the_middle
       alias into_the_middle     center # === into_the_middle
       alias align_to_the_center center # === align_to_the_center

end; end