#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/core_classes/vscale.rb'
# Gtk.vscale(0.0, 5.0, 0.1)
# =========================================================================== #
module Gtk

  require 'gtk_paradise/toplevel_methods/determine_which_gtk_version_is_in_use.rb'

  # ========================================================================= #
  # === Gtk.vscale
  # ========================================================================= #
  def self.vscale(
      optional_hash = {}
    )
    scale = Gtk::Scale.new(:vertical) # For ruby-gtk3.
    # ======================================================================= #
    # === Handle Hashes first
    # ======================================================================= #
    if optional_hash.is_a? Hash
      # ===================================================================== #
      # === :n_digits
      #
      # Usage example:
      #
      #   Gtk.vscale( n_digits: 30 )
      #
      # ===================================================================== #
      if optional_hash.has_key? :n_digits
        scale.set_digits(optional_hash.delete(:n_digits))
      end
    else # Else it is not a Hash, logically.
      scale = Gtk::Scale.new(*optional_hash)
    end
    return scale
  end

end