#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This module can be used to "draw" dynamically onto a gtk-window.
# =========================================================================== #
# require 'gtk_paradise/drawing/drawing.rb'
# =========================================================================== #
module Gtk

module Drawing

  require 'matrix'
  # require 'gtk2'
  require 'gtk_paradise/core_classes/window.rb'

  # ========================================================================= #
  # Load up the rest of the Drawing-related code:
  # ========================================================================= # 
  require 'gtk_paradise/drawing/event.rb'
  require 'gtk_paradise/drawing/star.rb'
  require 'gtk_paradise/drawing/tool.rb'
  require 'gtk_paradise/drawing/turtle.rb'

  # include Math # This line is probably no longer necessary.

  # ========================================================================= #
  # === W
  #
  # Refer to a new Window here.
  # ========================================================================= #
  W = ::Gtk::Window.new

  # ========================================================================= #
  # === Gtk::Drawing.app
  #
  # This will instantiate a new gtk-application.
  #
  # It can be used in a fairly flexible manner. For instance:
  #
  #   Drawing.app(width: Width, height: Height, title: 'tree') {
  #   }
  #
  # ========================================================================= #
  def self.app(
      width:     400,
      height:    400,
      title:     'drawing-module',
      resizable: false,
      &block
    )
    W.title = title
    W.set_size_request(width, height)
    W.set_resizable(resizable)
    W.set_app_paintable(true)
    W.realize
    W.signal_connect(:destroy) { Gtk.main_quit }
    W.show_all
    # ======================================================================= #
    # Add a new event:
    # ======================================================================= #
    e = Event.new
    e.width  = width
    e.height = height
    e.clear
    e.instance_eval(&block)
    Gtk.main
  end

end; end