#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::Drawing::Event
# =========================================================================== #
# require 'gtk_paradise/drawing/event.rb'
# =========================================================================== #
module Gtk

module Drawing

require 'gtk_paradise/drawing/tool.rb'

class Event < Tool # === Gtk::Drawing::Event

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super()
  end

  # ========================================================================= #
  # === draw
  # ========================================================================= #
  def draw(&block)
    W.signal_connect(:expose_event, &block)
  end

  # ========================================================================= #
  # === timer
  # ========================================================================= #
  def timer(interval, &block)
    Gtk.timeout_add(interval, &block)
  end

  # ========================================================================= #
  # === key_in
  # ========================================================================= #
  def key_in(&block)
    W.signal_connect(:key_press_event, &block)
  end

  # ========================================================================= #
  # === mouse_button
  # ========================================================================= #
  def mouse_button(&block)
    W.add_events(Gdk::Event::BUTTON_PRESS_MASK)
    W.signal_connect(:button_press_event, &block)
  end

  # ========================================================================= #
  # === make_window
  #
  # This method will create a new Gtk::Window.
  # ========================================================================= #
  def make_window(&block)
    w = Gtk::Window.new
    w.instance_eval(&block)
    w.show_all
    return w
  end

  # ========================================================================= #
  # === window_changed
  # ========================================================================= #
  def window_changed(&block)
    W.signal_connect(:configure_event) {
      @width, @height = get_window_size
      yield
    }
  end

end; end; end