#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::Emojis
#
# This file contains emojis, in a "hardcoded" manner. These emojis can be
# used in gtk-related applications. Keep in mind, however had, that these
# emojis may not be available on every computer system and they may appear
# differently on different computers.
#
# The emojis were initially manually copy-pasted into this file here,
# starting from December 2020 (05.12.2020 to be precise).
#
# It may be that these emojis will become outdated, or changed, so the time
# stamp for the file here should then also be modified, IF these emojis
# are changed as well. Just keep in mind that this is subject to change.
#
# Note that not all emojis are gathered here in this file, and it is
# very unlikely that all emojis will ever be collected here. The
# focus is mostly on those emojis that could be used in a ruby-gtk
# application.
#
# Specific usage examples:
#
#   Gtk::Emojis::SMILEY_6
#   Gtk::Emojis::ARROW_RIGHT
#
# =========================================================================== #
# require 'gtk_paradise/emojis/emojis.rb'
# Gtk::Emojis.map_emoji
# =========================================================================== #
module Gtk

module Emojis # === Gtk::Emojis

  require 'emoji_paradise'
  include ::EmojiParadise

  # ========================================================================= #
  # === Gtk::Emojis.map_emoji
  #
  # This method can be used to map the given input, which should be a
  # Symbol, to a particular emoji. Not all emojis are handled here; 
  # the method will be extended when necessary.
  #
  # Note that since as of January 2021, all input will be converted to
  # a Symbol. This was necessary because I added various flags of
  # different countries to the gtk_paradise gem, including the german
  # names for the different countries, which were stored as a String
  # in another project. Thus, we convert these strings to a Symbol
  # here.
  #
  # This then allows us to do the following:
  #
  #   gtk_label(:arrow_right)
  #   gtk_label(:vertical_line)
  #   gtk_label(:thinking_smiley)
  #   gtk_label(:open_file)
  #   gtk_label(:croatia)
  #   gtk_label(:clock_1)
  #   gtk_label(:directory)
  #
  # ========================================================================= #
  def self.map_emoji(
      i, be_verbose_when_nothing_was_found = true
    )
    return EmojiParadise.map_emoji(i, be_verbose_when_nothing_was_found)
  end; self.instance_eval { alias emoji_image map_emoji } # === Gtk::Emojis.emoji_image

  # ========================================================================= #
  # === Gtk::Emojis.is_this_an_emoji_symbol?
  # ========================================================================= #
  def self.is_this_an_emoji_symbol?(
      i, be_quiet_or_verbose = :default
    )
    EmojiParadise.is_this_an_emoji_symbol?(i, be_quiet_or_verbose)
  end

end; end

if __FILE__ == $PROGRAM_NAME
  alias e puts
  e Gtk::Emojis::SMILEY_1
end