#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::GridExample
# =========================================================================== #
# require 'gtk_paradise/gui/gtk3/examples/001_5x5_grid_example.rb'
# Gtk::GridExample.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class GridExample < ::Gtk::BaseModuleBox # === Gtk::GridExample 

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = '5x5 grid example'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '20% or minimum 200px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '15% or minimum 150px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_20

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    # ======================================================================= #
    # === @title
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    8
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    4
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    grid = default_grid
    grid.reset
    grid.pad10px
    grid.set_border_width(20)

    grid.left(button('1'))
    grid.middle(button('2'))
    grid.middle(button('3'))
    grid.middle(button('4'))
    grid.right(button('5'))

    grid.left(button('1'))
    grid.middle(button('2'))
    grid.middle(button('3'))
    grid.middle(button('4'))
    grid.right(button('5'))

    grid.left(button('1'))
    grid.middle(button('2'))
    grid.middle(button('3'))
    grid.middle(button('4'))
    grid.right(button('5'))

    grid.left(button('1'))
    grid.middle(button('2'))
    grid.middle(button('3'))
    grid.middle(button('4'))
    grid.right(button('5'))

    grid.left(button('1'))
    grid.middle(button('2'))
    grid.middle(button('3'))
    grid.middle(button('4'))
    grid.right(button('5'))

    maximal(grid, 20)
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    super()
  end

  # ========================================================================= #
  # === Gtk::GridExample.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::GridExample.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::GridExample.run
end # ruby 001_5x5_grid_example.rb