#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::LabelRespondingToEventsExample
# =========================================================================== #
# require 'gtk_paradise/gui/gtk3/gtk3_standalone/extensive_text_view_example.rb'
# Gtk::Gtk3Prototype.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class LabelRespondingToEventsExample < ::Gtk::BaseModuleBox

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Fancy Label'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = 1400

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = 500

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_22

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, infer_the_namespace]
    # ======================================================================= #
    # === @title
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    2
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === assign_the_content_of_the_fancy_label
  # ========================================================================= #
  def assign_the_content_of_the_fancy_label
    @fancy_label.simple_markup(
      'F',  :steelblue,
      'a',  :royalblue,
      'n',  :steelblue,
      'c',  :olivedrab,
      'y ', :darkgreen,
      'L',  :steelblue,
      'a',  :lightgreen,
      'b',  :royalblue,
      'e',  :royalblue,
      'l',  :royalblue,
      ' - simply try to do some events on this '\
      'label such as pressing the enter-key'
    )
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    @fancy_label = left_aligned_label
    assign_the_content_of_the_fancy_label
    @fancy_label.enable_all_events
    @fancy_label.make_selectable
    @fancy_label.signal_connect(:event) {|widget, event|
      if event.is_a? Gdk::EventKey
        e 'SOME KEY WAS PRESSED!' unless is_enter_key?(event)
      end
    }
    @fancy_label.on_enter { e 'The enter key was pressed.' }
    minimal(
      @fancy_label
    )
    Thread.new {
      sleep 0.001
      deselect_the_main_label
    }
  end

  # ========================================================================= #
  # === deselect_the_main_label
  # ========================================================================= #
  def deselect_the_main_label
    print ' '
    @fancy_label.deselect
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    super()
  end

  # ========================================================================= #
  # === Gtk::LabelRespondingToEventsExample.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::LabelRespondingToEventsExample.new(i)
    r = ::Gtk.run
    r << _
    r.automatic
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::LabelRespondingToEventsExample.run
end