#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::LeanCSSExample
# =========================================================================== #
# require 'gtk_paradise/example/advanced/017_lean_CSS_example.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class LeanCSSExample < ::Gtk::BaseModuleBox

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Advanced CSS example'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = 1280

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = 580

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_22

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, infer_the_namespace]
    # ======================================================================= #
    # === @title
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
    # ======================================================================= #
    # Add more CSS next:
    # ======================================================================= #
    more_CSS_then_apply_it '
.blightgreen5 { border: 8px solid lightgreen; }
.bblack5      { border: 8px solid black; }
.bgreen5      { border: 8px solid green; }

.yoda {
  color: yellow;
}

.BG_Black {
  background-color: black;
}

.hover1 {
  font-size: 80px;
  background-image: none;
  border: 2px solid black;
}

.hover1:hover {
  transition: 4000ms linear;
  background-color: lightblue;
}

.hover1:focus {
  transition: border 100ms ease-in;
  background-color: royalblue;
}

.slider1 {
  border-style: solid;
  border-width: 2px;
  border-color: #a7a7a7;
  border-radius: 50% 50% 0 50%;
  background-image: linear-gradient(15deg, #ededed, steelblue);
  box-shadow: inset 0 0 0 2px rgba(255,255,255,0.2),
              2px 2px 2px rgba(0,0,0,0.1);
}

.box_shadow1 {
  box-shadow: inset 1px 0 alpha(tomato, 0.10),
              inset 0 1px alpha(tomato, 0.12),
              inset -1px 0 alpha(tomato, 0.15),
              inset 0 -1px alpha(tomato, 0.05);
}

.foobar       label { color: tomato }
.foobar:hover label { text-shadow: none; color: steelblue; }

.foobar:hover
{
  background-image: none;
  border-color: shade(darkgreen, 0.7);
  background-color: shade(lightgreen, 1.10);
}

'
    use_lean_CSS_rules
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    2
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    minimal(gtk_left_aligned_label('Showcasing CSS-buttons next.'))

    button1 = button('Button #1')
    button1.width_height(30, 30)
    button1.css_class 'clear_background'
    button1.css_class 'blightgreen5'
    button1.disallow_resizing

    button2 = button('Button #2')
    button2.width_height(30, 30)
    button2.css_class 'bblack5'
    button2.disallow_resizing

    button3 = button('Button #3')
    button3.width_height(30, 30)
    button3.css_class 'bgreen5'
    button3.disallow_resizing

    minimal(button1, 3)
    minimal(button2, 3)
    minimal(button3, 3)
    minimal(text('Next, showing a transparent widget'))
    button4 = button('Button #4')
    button4.width_height(30, 30)
    button4.css_class 'bgreen5'
    button4.css_class 'transparent'
    button4.disallow_resizing
    minimal(button4, 3)

    button5 = button('Button #5')
    button5.width_height(30, 30)
    button5.css_class 'bgreen5'
    button5.disallow_resizing
    button5.use_this_font = 'Cantarell Bold 11'
    minimal(button5, 3)

    entry = gtk_entry('This is a test for Gtk::Entry.')
    entry.set_name('hover1')
    entry.yellowish_background
    entry.bblack1
    entry.width_height(150, 50)
    hbox = gtk_vbox
    hbox.minimal(entry, 5)
    minimal(hbox, 5)

    box = hbox
    box.add(
      bold_text('This is just some text via box-shadow CSS effects.')
    )
    box.css_class('slider1')
    minimal(box, 15)

    minimal(box, 25)
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    # We have to either manually run the method called apply_the_css_string()
    # or we will let Gtk::Runner do this for us when .run() is called.
    apply_the_css_string # For now this has to be called manually.
    create_skeleton_then_connect_skeleton
  end

  # ========================================================================= #
  # === Gtk::LeanCSSExample.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::LeanCSSExample.new(i)
    r = ::Gtk.run
    r << _
    r.automatic
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::LeanCSSExample.run
end