#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

alias e puts

def on_destroy(widget)
  Gtk.main_quit
  return false
end

def scroll_notify_event(w, event)
  if event.direction == Gdk::ScrollDirection::UP
    puts 'You scrolled up.'
  elsif event.direction == Gdk::ScrollDirection::DOWN
    puts 'You scrolled down.'
  end
end

window = Gtk::Window.new
window.signal_connect(:destroy) { |widget| on_destroy(widget) }
hbox = Gtk::Box.new(:vertical)

entry = Gtk::Entry.new
entry.make_scrollable
entry.signal_connect(:event) {|widget, event|
  if Gtk.scroll_up_event?(event)
    e 'Scroll up event.'
  elsif Gtk.scroll_down_event?(event)
    e 'Scroll down event.'
  end
}

hbox.add(entry)
window.add(hbox)
window.set_size_request(500, 150)
window.show_all
Gtk.main