#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::AppendImageToBuffer
# =========================================================================== #
# require 'gtk_paradise//gtk3/023_image_in_label_example.rb'
# Gtk::AppendImageToBuffer.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class AppendImageToBuffer < ::Gtk::BaseModuleBox # === Gtk::AppendImageToBuffer 

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Image in label example'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '22% or minimum 200px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '12% or minimum 100px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_18

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    # ======================================================================= #
    # === Set the title, width, height and the font in use.
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    4
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    text_buffer = gtk_text_buffer
    text_view   = gtk_text_view(text_buffer)
    text_buffer.set_text("Hello world!\n")
    # Here we append the image onto the buffer.
    text_buffer.append_this_image(
      project_base_directory?+
      'images/icons/icon_smile.gif'
    )
    text_buffer.append_this_image(:smiley) # And an alias to the ^^^ above.
    text_buffer.append_this_image(:smiley) # Using the Symbol version is really easier.
    text_buffer.append_this_image(:smiley)
    text_buffer.append_this_image(:smiley)
    text_buffer.append_this_image(:smiley)
    scrolled_window = gtk_scrolled_window(text_view)
    scrolled_window.width_height(500, 400)
    minimal(
      scrolled_window
    )
  end

  # ========================================================================= #
  # === create_skeleton                            (create tag, skeleton tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    super()
  end

  # ========================================================================= #
  # === Gtk::AppendImageToBuffer.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::AppendImageToBuffer.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::AppendImageToBuffer.run
end