#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ParseIntoTableExample
#
# This example shows how to scale up an image.
# =========================================================================== #
# require 'gtk_paradise/gui/gtk3/advanced/020_scale_this_image.rb'
# Gtk::ParseIntoTableExample.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class ParseIntoTableExample < ::Gtk::BaseModuleBox # === Gtk::ParseIntoTableExample 

  begin
    require 'studium/toplevel_methods/toplevel_methods.rb'
  rescue LoadError; end

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Parse into table'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '55% or minimum 200px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '55% or minimum 100px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_20

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, infer_the_namespace]
    # ======================================================================= #
    # === @title
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    12
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    8
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    vbox = create_vbox
    vbox << left_aligned_selectable_text('This shows how to use the method parse_into_table()')
    table = parse_into_table '/Depot/j/animals.yml'
    vbox.minimal(table, 8)
    scrolled_window = create_scrolled_window(vbox)
    maximal(scrolled_window)
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    super()
  end

  # ========================================================================= #
  # === Gtk::ParseIntoTableExample.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::ParseIntoTableExample.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::ParseIntoTableExample.run
end