#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk3'

class CairoWriteviaCustomFont < Gtk::Window

  # ========================================================================= #
  # === USE_THIS_FONT_FACE
  # ========================================================================= #
  USE_THIS_FONT_FACE = 'Hack' # 'Chandas'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super()
    run
  end
  
  # ========================================================================= #
  # === init_ui
  # ========================================================================= #
  def init_ui
    @darea = Gtk::DrawingArea.new  
    @darea.signal_connect(:draw) { on_draw }
    add @darea 
  end
  
  # ========================================================================= #
  # === on_draw
  # ========================================================================= #
  def on_draw
    cr = @darea.window.create_cairo_context  
    draw_lyrics(cr)
  end
  
  # ========================================================================= #
  # === draw_lyrics
  # ========================================================================= #
  def draw_lyrics(cr)
    cr.set_source_rgb 0.1, 0.1, 0.1
    # ======================================================================= #
    # Select the font to use next.
    # ======================================================================= #
    cr.select_font_face USE_THIS_FONT_FACE, Cairo::FONT_SLANT_NORMAL, 
                        Cairo::FONT_WEIGHT_NORMAL
    cr.set_font_size 35
    cr.move_to 20, 30
    cr.show_text 'Most relationships seem so transitory'
    cr.move_to 20, 60
    cr.show_text "They're all good but not the permanent one"
    cr.move_to 20, 120
    cr.show_text "Who doesn't long for someone to hold"
    cr.move_to 20, 150
    cr.show_text 'Who knows how to love without being told'
    cr.move_to 20, 180
    cr.show_text "Somebody tell me why I'm on my own"
    cr.move_to 20, 210
    cr.show_text "If there's a soulmate for everyone"
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    set_title 'Soulmate'
    signal_connect(:destroy) { Gtk.main_quit }
    init_ui
    set_default_size(1024, 640)
    set_window_position :center
    show_all
  end

end

if __FILE__ == $PROGRAM_NAME
  CairoWriteviaCustomFont.new
  Gtk.main
end