#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk3'

class CairoDonut < Gtk::Window

  # ========================================================================= #
  # === DRAW_N_ELLIPSES
  # ========================================================================= #
  DRAW_N_ELLIPSES = 36

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super
    reset
    set_title 'Donut'
    signal_connect(:destroy) { Gtk.main_quit }
    init_ui
    set_default_size 550, 350
    set_window_position :center
    show_all
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    @line_width_to_use = 0.85
  end

  # ========================================================================= #
  # === init_ui
  # ========================================================================= #
  def init_ui
    # ======================================================================= #
    # === @drawing_area
    #
    # We will draw onto this area.
    # ======================================================================= #
    @drawing_area = Gtk::DrawingArea.new  
    @drawing_area.signal_connect(:draw) { on_draw }
    add(@drawing_area)
  end

  # ========================================================================= #
  # === on_draw
  # ========================================================================= #
  def on_draw
    cr = @drawing_area.window.create_cairo_context  
    draw_donut(cr)
  end
  
  # ========================================================================= #
  # === draw_donut
  # ========================================================================= #
  def draw_donut(cr = @drawing_area.window.create_cairo_context)
    cr.set_line_width @line_width_to_use
    w = allocation.width
    h = allocation.height
    # First, we draw the outer ellipse.
    cr.translate w/2, h/2
    cr.arc(0, 0, 120, 0, 2*Math::PI)
    cr.stroke
    # ======================================================================= #
    # Next, we set all other ellipses, 36 by default.
    # These ellipses will be created along the path of the bounding circle.
    # We insulate each rotate and scale operation from one another with
    # the save() and restore() methods. 
    # ======================================================================= #
    for i in 1..DRAW_N_ELLIPSES
      cr.save
      cr.rotate i * Math::PI/DRAW_N_ELLIPSES
      cr.scale 0.3, 1
      cr.arc 0, 0, 120, 0, 2*Math::PI
      cr.restore
      cr.stroke
    end
  end

end

if __FILE__ == $PROGRAM_NAME
  CairoDonut.new
  Gtk.main
end # cairo_transparent_rectangles.rb