#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This example will draw some stars.
# =========================================================================== #
require 'gtk_paradise/drawing/drawing.rb'

# =========================================================================== #
# === DIMENSION
# =========================================================================== #
DIMENSION = 400

Drawing.app(width: DIMENSION, height: DIMENSION) {

  # ========================================================================= #
  # === BASE_FACTOR_USED_BY_GTK_FOR_RGB_VALUES
  # ========================================================================= #
  BASE_FACTOR_USED_BY_GTK_FOR_RGB_VALUES = 65535

  # ========================================================================= #
  # === USE_THIS_COLOUR_IN_RGB_VALUE
  #
  #   255 ... 65535
  #     0 ...   0
  #
  # ========================================================================= #
  USE_THIS_COLOUR_IN_RGB_VALUE = [
    BASE_FACTOR_USED_BY_GTK_FOR_RGB_VALUES / 255 *  63.8,
    BASE_FACTOR_USED_BY_GTK_FOR_RGB_VALUES / 255 * 100.0,
    BASE_FACTOR_USED_BY_GTK_FOR_RGB_VALUES / 255 *  94.9
  ] # R: 21.0, G: 71.0, B: 64.0 (is teal)

  draw {
    clear
    color(*USE_THIS_COLOUR_IN_RGB_VALUE)
    po = Vector[0, 50]
    θ = Math::PI / 15
    a = Matrix[
      [
        Math.cos(θ),
        -Math.sin(θ)
      ],
      [
        Math.sin(θ),
        Math.cos(θ)
      ]
    ]
    for y in 0..3
      for x in 0..3
        x1 = x * 100 + 50
        y1 = y * 100 + 50
        star(false, x1, y1, x1 + po[0], y1 - po[1])
        po = a * po
      end
    end
  }
}