#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk_paradise/drawing/drawing.rb'

Width  = 400
Height = 300
Turn   =  20
Length =  40
Ratio  =   0.9
Depth  =   8

θ = Math::PI * Turn / 180
left  = Matrix[[Math.cos(θ),  -Math.sin(θ)],  [Math.sin(θ),  Math.cos(θ)]]
right = Matrix[[Math.cos(-θ), -Math.sin(-θ)], [Math.sin(-θ), Math.cos(-θ)]]

Drawing.app(width: Width, height: Height, title: 'tree') {
  draw {
    clear
  }

  ar = [[Vector[Width / 2, 1], Vector[0, Length]]]
  branch_num = 0

  id = timer(80) {
    ob = ar.shift
    v1 = left  * ob[1]
    v2 = right * ob[1]
    p1 = ob[0] + v1
    p2 = ob[0] + v2

    color(0, 65535, 0)
    line(ob[0][0], Height - ob[0][1], p1[0], Height - p1[1])
    line(ob[0][0], Height - ob[0][1], p2[0], Height - p2[1])

    ar << [p1, v1 * Ratio]
    ar << [p2, v2 * Ratio]
    branch_num += 2
    timer_stop(id) if branch_num >= 2 ** (Depth + 1) - 2
    true
  }
}