#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk_paradise/drawing/drawing.rb'

# =========================================================================== #
# === WIDTH
# =========================================================================== #
WIDTH  = 600

# =========================================================================== #
# === HEIGHT
# =========================================================================== #
HEIGHT = 400

Drawing.app(
    width:  WIDTH,
    height: HEIGHT,
    title: 'A moving turtle'
  ) {
  draw {
    clear

    turtle = Drawing::Turtle.new
    turtle.move(-130, -100) # x-start point comes first.
    turtle.color(0, 65535, 0) # This is a light green colour.
    ratio = Math.sqrt(2) / 2 # This is the ratio: 0.7071067811865476

    drawing = lambda { |length, depth|
      if depth.zero?
        turtle.forward(length)
      else
        turtle.left(45)
        drawing[length * ratio, depth - 1]
        turtle.right(90)
        drawing[length * ratio, depth - 1]
        turtle.left(45)
      end
    }
    drawing[260.0, 10]
  }
}