#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk3'

alias e puts

e 'Next testing GLib::Param::Int.new'

spec = GLib::Param::Int.new('integer',         # name
  'Integer',         # nick
  'Integer integer', # blurb
  0,                 # min
  10000,             # max
  0,                 # default
  GLib::Param::READABLE|
  GLib::Param::WRITABLE
)

enum = GLib::Param::Enum.new(
   'enum',                      # name
   'Enum',                      # nick
   'Enum enum',                 # blurb
   GLib::Type['GdkCursorType'], #type
   Gdk::Cursor::ARROW,          #default
   GLib::Param::READABLE|
   GLib::Param::WRITABLE
)

flags = GLib::Param::Flags.new(
  'flags',                       # name
  'Flags',                       # nick
  'Flags flags',                 # blurb
  GLib::Type['GdkEventMask'],    #type
  Gdk::Event::LEAVE_NOTIFY_MASK, #default
  GLib::Param::READABLE|
  GLib::Param::WRITABLE
)
e
e 'Next, various Gtk::Settings properties will be displayed.'
e

p Gtk::Settings.rc_property_parse_color(spec, "{2222,44444,65535}").to_a
p Gtk::Settings.rc_property_parse_enum(enum, 'watch')
p Gtk::Settings.rc_property_parse_flags(flags, "(scroll-mask|structure-mask)")
p Gtk::Settings.rc_property_parse_requisition(spec, "{100, 200}")
p Gtk::Settings.rc_property_parse_border(spec, "{100, 200, 300, 400}").to_a
