#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === TooltipsExample
#
# We use a class here, simply as that is better for re-use of code.
# =========================================================================== #
# require 'gtk2'
require 'gtk_paradise/requires/require_gtk2.rb'

module Gtk

class TooltipsExample < HBox # === TooltipsExample

  alias e puts

  # ========================================================================= #
  # === FONT_TO_USE
  # ========================================================================= #
  arity = Pango::FontDescription.method(:new).arity 

  if arity > 0
    FONT_TO_USE = Pango::FontDescription.new('Arial 20')
  else
    FONT_TO_USE = Pango::FontDescription.new
  end

  # ========================================================================= #
  # === USE_THIS_TOOLTIP
  # ========================================================================= #
  USE_THIS_TOOLTIP = ' And <span weight="bold" foreground="darkgreen">'\
    'different colour</span> in this way. '

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super()
    run if run_already
  end

  # ========================================================================= #
  # === set_the_font_for_this_application
  # ========================================================================= #
  def set_the_font_for_this_application
    modify_font(FONT_TO_USE)
  end

  # ========================================================================= #
  # === create_the_buttons
  # ========================================================================= #
  def create_the_buttons
    @button1 = Gtk::Button.new('Button 1')
    @button1.signal_connect(:clicked) {
      e 'Button 1'
    }
    @button2 = Gtk::Button.new('Button 2')
    @button2.signal_connect(:clicked) {
      e 'Button 2'
    }
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    create_the_buttons
    @button1.modify_font(FONT_TO_USE)
    add(@button1)
    @button1.tooltip_markup = ' This tooltip appears in <b>bold</b>. '

    @button2.modify_font(FONT_TO_USE)
    add(@button2)
    # ======================================================================= #
    # This variant uses darkgreen as a colour.
    # ======================================================================= #
    @button2.tooltip_markup = USE_THIS_TOOLTIP
    set_the_font_for_this_application
    show_all
  end

end; end

if __FILE__ == $PROGRAM_NAME
  tooltips_example = Gtk::TooltipsExample.new
  window = Gtk::Window.new(:horizontal)
  window.add(tooltips_example)
  window.show_all
  window.set_size_request(800, 800)
  font = Pango::FontDescription.new('Hack 22')
  window.modify_font(font)
  window.move(0, 0)
  Gtk.main
end # tooltipsexample