#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk2'

alias e puts

window = Gtk::Window.new
window.title = 'A hello-world button'
window.signal_connect(:destroy) { ::Gtk.main_quit }
button = Gtk::Button.new
button.label = 'Hello world!'
# Either use :clicked:
# button.signal_connect(:clicked) {
#   e 'Hello world!'
# }
# Or handle the events as-is:
button.signal_connect(:event) {|widget, event|
  if event.is_a?(Gdk::EventButton) and (event.event_type.name == 'GDK_BUTTON_PRESS')
    case event.button
    when 1
      e 'The left-mouse-button was clicked.'
    when 2
      e 'The middle-mouse-button was clicked.'
    when 3
      e 'The right-mouse-button was clicked.'
    end
  end
}
  
hbox = Gtk::HBox.new
hbox.add(button)
window.add(hbox)
window.show_all
window.set_size_request(800, 300)
window.move(0, 0)
Gtk.main