#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk2'

alias e puts

window = Gtk::Window.new
window.move(0, 0)
scale_button = Gtk::ScaleButton.new(::Gtk::IconSize::BUTTON)
window.add(scale_button)

scale_button.set_icons(
  %w(
    go-bottom go-top system-run
  )
)
# gtk-goto-bottom gtk-goto-top gtk-execute
# ^^^ these variants do not work.
scale_button.signal_connect(:value_changed) { |widget, value|
  e "The value has changed to: "\
    "\e[38;2;218;165;32m#{value}\e[0;37m"
}

window.set_default_size(200, 200) 
window.show_all
Gtk.main