#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === colour_around_button.rb
#
# This example shows how to do a "border" around a button in ruby-gtk2,
# by cheating a bit aka by simply using a frame, and then using
# .modify_bg() on that frame.
# =========================================================================== #
require 'gtk2'

::Gtk::Settings.default.gtk_font_name = 'Mono 22'

# =========================================================================== #
# === USE_THIS_COLOUR
#
# Specify the colour to use here.
# =========================================================================== #
USE_THIS_COLOUR = 'steelblue'

window = Gtk::Window.new
window.signal_connect(:destroy) { Gtk.main_quit }
window.set_size_request(500, 300)

vbox = Gtk::VBox.new
frame = Gtk::Frame.new
frame.modify_bg(
  ::Gtk::STATE_NORMAL,
  Gdk::Color.parse(USE_THIS_COLOUR)
)
frame.set_shadow_type(Gtk::SHADOW_IN)
frame.set_border_width(40)

text_to_use = 'Click me'
button = Gtk::Button.new(text_to_use)

button.set_size_request(200, 50)
button.signal_connect(:clicked) { puts 'Clicked on it.' }
frame.add(button)
vbox.pack_start(frame, false, false)

# create the body_text and place it below the title
label2 = Gtk::Label.new('This is the body text.')
vbox.pack_start(label2, false, false, 5)
window.add(vbox)
window.show_all
window.move(0, 0)
Gtk.main