#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This is just a simple gtk-label example for ruby-gtk2.
# =========================================================================== #
# require 'gtk_label_example.rb'
# =========================================================================== #
require 'gtk2'

::Gtk::Settings.default.gtk_font_name = 'Sans 20'

heredoc = <<-EOF
Hello world!

This is an example for a more complicated Gtk::Label.

You can use markup, thus colours, by making use of:

    .set_text()

and

    .use_markup = true

Some <a href="http://en.wikipedia.org/wiki/Text" title="plain text">text</a> 
may be marked up as hyperlinks, which can be clicked
or activated via <a href="keynav">keynav</a>
and they work fine with other markup, like when
searching on <a href="http://www.google.com/">
  <span color="#0266C8">G</span><span color="#F90101">o</span>
  <span color="#F2B50F">o</span><span color="#0266C8">g</span>
  <span color="#00933B">l</span><span color="#F90101">e</span>
  </a>
EOF


w = Gtk::Window.new

hbox = Gtk::HBox.new

label1 = Gtk::Label.new
label1.set_text(heredoc)
label1.use_markup = true
hbox.add(label1)

label2 = Gtk::Label.new(
  ' This is the second label - it is shifted',
  true
)
label2.angle = 5
hbox.add(label2)
    
hbox.show_all
w.add(hbox)
w.show_all
w.set_size_request(680, 650)
w.move(0, 0)
Gtk.main