#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This tiny class just exists to show how Gtk::MessageDialog is used,
# without any additional code. Thus, this is code that works "out of
# the box" - at the least for gtk2.
# =========================================================================== #
require 'gtk2'

class ExampleDialog

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    @window = Gtk::Window.new
    @window.move(0, 0)
    # ======================================================================= #
    # Next instantiate a new message-dialog:
    # ======================================================================= #
    @message_dialog = Gtk::MessageDialog.new(
      @window,
      Gtk::Dialog::MODAL,
      Gtk::MessageDialog::ERROR,
      Gtk::MessageDialog::BUTTONS_CLOSE,
      'This is just an example message, for the user of the '\
      'gtk-application to see.'
    )
    @message_dialog.run
    @message_dialog.destroy
  end

end

if __FILE__ == $PROGRAM_NAME
  ExampleDialog.new # rb $RUBY_GTK/message_dialog.rb
end