#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/examples/gtksourceview2_example.rb'
# =========================================================================== #
require 'gtksourceview2'

window = Gtk::Window.new
window.signal_connect(:delete_event) { Gtk.main_quit }

Gtk::Settings.default.gtk_font_name = 'Sans 22'

# =========================================================================== #
# Add a Gtk::SourceView instance next, before setting up some sane defaults.
# =========================================================================== #
source_view = Gtk::SourceView.new
source_view.show_line_numbers = true
source_view.insert_spaces_instead_of_tabs = true
source_view.indent_width = 2
source_view.show_right_margin = true
source_view.right_margin_position = 80

# =========================================================================== #
# gtksourceview2 also defines Gtk::SourceLanguageManager.
# =========================================================================== #
ruby_lang = Gtk::SourceLanguageManager.new.get_language('ruby')
# =========================================================================== #
# This will be assigned to the source-view buffer next:
# =========================================================================== #
source_view.buffer.language = ruby_lang
source_view.buffer.highlight_syntax = true
source_view.buffer.highlight_matching_brackets = true
source_view.buffer.set_text "class Foobar\n  # this is an example class\nend\n"

vbox = Gtk::VBox.new
vbox.add(Gtk::ScrolledWindow.new.add(source_view))
window.add(vbox)
window.set_default_size(1200, 800)
window.move(0, 0)
window.show_all
Gtk.main # ruby $RUBY_GTK/gtksou*test.rb