#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# Keep in mind that this is for ruby-gtk2; if you need this for ruby-gtk3
# then make use of 061_gtk_entry.rb instead.
# =========================================================================== #
require 'gtk2'

alias e puts

window = Gtk::Window.new('a gtk-entry example')
window.border_width = 5
window.move(0, 0)

box1 = Gtk::VBox.new(false, 10)

entry = Gtk::Entry.new
entry.signal_connect(:event) { |widget, event|
  case event.event_type.name
  when 'GDK_SCROLL'
    case event.direction
    when Gdk::ScrollDirection::UP
      e 'scrolled up!'
    when Gdk::ScrollDirection::DOWN
      e 'scrolled down!'
    end
  end
}

entry.text = 'This is a long example sentence, just '\
             'demonstrating an instance of Gtk::Entry.'
entry.inner_border = Gtk::Border.new(30, 1, 50, 5)
entry.select_region(0, 1)

box1.add(entry)
box1.add(Gtk::HSeparator.new)

button = Gtk::Button.new('close')
button.signal_connect(:clicked) { Gtk.main_quit }
box1.pack_start(button, false, false, 20)

window.add(box1)
window.signal_connect(:destroy) { Gtk.main_quit }
window.show_all.set_size_request(800, 600)
window.move(0, 0)
Gtk.main