#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This example shows how to open a right-menu drop down interface.
# =========================================================================== #
require 'gtk2'

alias e puts

window = Gtk::Window.new

# =========================================================================== #
# Build up a context-menu interface next.
# =========================================================================== #
context_menu = Gtk::Menu.new
context_menu.append(mitem1 = Gtk::MenuItem.new('Test1'))
context_menu.append(mitem2 = Gtk::MenuItem.new('Test2'))
context_menu.append(mitem3 = Gtk::MenuItem.new('Test3'))
context_menu.append(mitem4 = Gtk::MenuItem.new('Test4'))
context_menu.append(mitem5 = Gtk::MenuItem.new('Test5'))
context_menu.show_all

# =========================================================================== #
# Next, let these menu-items respond to when the user activates them.
# =========================================================================== #
mitem1.signal_connect(:activate) { |widget| puts "#{widget.class} - Test1" }
mitem2.signal_connect(:activate) { |widget| puts "#{widget.class} - Test2" }
mitem3.signal_connect(:activate) { |widget| puts "#{widget.class} - Test3" }
mitem4.signal_connect(:activate) { |widget| puts "#{widget.class} - Test4" }
mitem5.signal_connect(:activate) { |widget| puts "#{widget.class} - Test5" }

e
e 'click the right mouse button to show the context-menu'
e

event_box = Gtk::EventBox.new
event_box.signal_connect(:button_press_event) { |widget, event|
  case event.event_type
  when Gdk::Event::BUTTON_PRESS # normaler klick, simple click
    e 'This is a simple mouse-button event. We next differentiate'
    e 'between which mouse button has been pressed.'
    case event.button
    when 1
      e 'left' # left button
    when 2
      e 'middle button'
    else # right button, which will trigger the popup-action.
      context_menu.popup(nil, nil, event.button, event.time)
    end
  when event.event_type == Gdk::Event::BUTTON2_PRESS # doppelklick
    # p "double click"
  when event.event_type == Gdk::Event::BUTTON3_PRESS # trippelklick
    # p "triple click"
  when event.event_type == Gdk::Event::BUTTON_RELEASE
    # p "mausknopf wurde losgelassen"
  end
}

window.add(event_box)
window.show_all
window.set_size_request(800, 600)
window.move(0, 0)
Gtk.main