#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This file shows an example how to deal with Gtk::Dialog.
# =========================================================================== #
# require 'gtk_dialog_sample.rb'
# =========================================================================== #
require 'gtk2'

class GtkDialogSample < Gtk::Dialog

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Gtk::Dialog Sample'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super()
    set_title TITLE
    set_default_size(600, 250)
    move(0, 0)
    vbox.add(Gtk::Label.new('Gtk::Dialog Sample'))
    add_button('OK', Gtk::Dialog::RESPONSE_OK)
    add_button(Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_CANCEL)
    add_button(Gtk::Stock::CLOSE, Gtk::Dialog::RESPONSE_CLOSE)
    set_default_response(Gtk::Dialog::RESPONSE_CANCEL)
    signal_connect(:response) { |widget, response|
      case response
      when Gtk::Dialog::RESPONSE_OK
        p 'OK'
      when Gtk::Dialog::RESPONSE_CANCEL
        p 'Cancel'
      when Gtk::Dialog::RESPONSE_CLOSE
        p 'Close'
        destroy
        Gtk.main_quit
      end
    }
    show_all
  end

end

if __FILE__ == $PROGRAM_NAME
  GtkDialogSample.new
  Gtk.main  
end # rb gtk_dialog_sample.rb