#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This file demonstrates how to use Gtk::Listview, for ruby-gtk2.
# =========================================================================== #
# require 'list_view.rb'
# =========================================================================== #
require 'gtk2'

window = Gtk::Window.new
window.border_width = 0
box1 = Gtk::VBox.new(false, 0)
window.add(box1)
box2 = Gtk::VBox.new(false, 10)
box2.border_width = 10
box1.pack_start(box2, true, true, 0)
scrolled_window = Gtk::ScrolledWindow.new
scrolled_window.set_policy(Gtk::POLICY_AUTOMATIC,Gtk::POLICY_AUTOMATIC)
box2.pack_start(scrolled_window, true, true, 0)

dataset = %w(
  hello
  world
  blah
  foo
  bar
  argh
  spencer
  is 
  a
  wussy
  programmer
)

list_store = Gtk::ListStore.new(String)
column = Gtk::TreeViewColumn.new('Data',
  Gtk::CellRendererText.new, { text: 0}
)
treeview = Gtk::TreeView.new(list_store)
treeview.expand_all
treeview.append_column(column)
treeview.selection.set_mode(Gtk::SELECTION_SINGLE)
scrolled_window.add_with_viewport(treeview)
dataset.each { |entry|
  iter = list_store.append
  iter[0] = entry
}
# The next button can be used to add a new entry.
button = Gtk::Button.new('add')
button.set_flags(Gtk::Widget::CAN_FOCUS)
i = 0
button.signal_connect(:clicked) {
  iter = list_store.append
  iter[0] = "add item #{i}"
  i += 1
}
box2.pack_start(button, false, true, 0)
# =========================================================================== #
# Add the remove-button next:
# =========================================================================== #
button = Gtk::Button.new(:remove)
button.set_flags(Gtk::Widget::CAN_FOCUS)
button.signal_connect(:clicked) {
  iter = treeview.selection.selected
  list_store.remove(iter) if iter
}
box2.pack_start(button, false, true, 0)
separator = Gtk::HSeparator.new
box1.pack_start(separator, false, true, 0)
separator.show
box2 = Gtk::VBox.new(false, 10)
box2.border_width = 10
box1.pack_start(box2, false, true, 0)
button = Gtk::Button.new(:close)
button.signal_connect(:clicked) { Gtk.main_quit }
box2.pack_start(button, true, true, 0)
button.set_flags(Gtk::Widget::CAN_DEFAULT)
button.grab_default
window.set_default_size(500, 500)
window.move(0, 0)
window.show_all
Gtk.main # rb tree_view_column_example.rb