#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk2'

# =========================================================================== #
# Designate which variant to use for the entry points below:
# =========================================================================== #
which = 2

# =========================================================================== #
# === make_box
#
# Make a box with button-labels. Arguments for the variables
# we're interested are passed in to this function.
# =========================================================================== #
def make_box(homogeneous, spacing, expand, fill, padding)
  hbox = Gtk::HBox.new(homogeneous, spacing)
  # Create some buttons.
  button = Gtk::Button.new "box.pack "
  hbox.pack_start button, expand, fill, padding
  button = Gtk::Button.new "button, "
  hbox.pack_start button, expand, fill, padding
  button = Gtk::Button.new "#{expand}, "
  hbox.pack_start button, expand, fill, padding
  button = Gtk::Button.new "#{fill}, "
  hbox.pack_start button, expand, fill, padding
  button = Gtk::Button.new "#{padding}"
  hbox.pack_start button, expand, fill, padding
  hbox
end

window = Gtk::Window.new
window.set_size_request(800, 560)
# This time we connect the 'delete_event' signal straight to Gtk.main_quit
# so we don't need to connect the 'destroy' signal.
window.signal_connect(:delete_event) { Gtk.main_quit }

window.set_border_width(10)
window.move(0, 0)
Gtk::Settings.default.gtk_font_name = 'Sans 24'

# Create a vertical box to pack the horizontal boxes into.
vbox = Gtk::VBox.new(false, 0)
window.add vbox

case which.to_s
when '1'
  label = Gtk::Label.new('Gtk::HBox.new(false, 0)')
  vbox.pack_start label, false, false, 0

  hbox = make_box(false, 0, false, false, 0)
  vbox.pack_start hbox, false, false, 0

  hbox = make_box(false, 0, true, false, 0)
  vbox.pack_start hbox, false, false, 0

  hbox = make_box(false, 0, true, true, 0)
  vbox.pack_start hbox, false, false, 0
  separator = Gtk::HSeparator.new
  vbox.pack_start(separator, false, true, 5)

  label = Gtk::Label.new('Gtk::HBox.new(true, 0)')
  vbox.pack_start label, false, false, 0

  hbox = make_box(true, 0, true, false, 0)
  vbox.pack_start hbox, false, false, 0

  hbox = make_box(true, 0, true, true, 0)
  vbox.pack_start hbox, false, false, 0

  separator = Gtk::HSeparator.new
  vbox.pack_start(separator, false, true, 5)

when '2'
  label = Gtk::Label.new('Gtk::HBox.new(false, 10)')
  vbox.pack_start label, false, false, 0

  hbox = make_box(false, 10, true, false, 0)
  vbox.pack_start hbox, false, false, 0

  hbox = make_box(false, 10, true, true, 0)
  vbox.pack_start hbox, false, false, 0

  separator = Gtk::HSeparator.new
  vbox.pack_start(separator, false, true, 5)

  label = Gtk::Label.new('Gtk::Hbox.new(false, 0)')
  vbox.pack_start label, false, false, 0

  hbox = make_box(false, 0, true, false, 10)
  vbox.pack_start hbox, false, false, 0

  hbox = make_box(false, 0, true, true, 10)
  vbox.pack_start hbox, false, false, 0

  separator = Gtk::HSeparator.new
  vbox.pack_start(separator, false, true, 5)

  label = Gtk::Label.new('Gtk::Hbox.new(false, 0)')
  vbox.pack_start label, false, false, 0

  hbox = make_box(false, 0, true, false, 10)
  vbox.pack_start hbox, false, false, 0

  hbox = make_box(false, 0, true, true, 10)
  vbox.pack_start hbox, false, false, 0

  separator = Gtk::HSeparator.new
  vbox.pack_start(separator, false, true, 5)

when '3'
  # ========================================================================= #
  # This demonstrates how we can use pack_end to right-justify
  # widgets. You will have to resize the window to see the
  # right justification.
  # ========================================================================= #
  hbox = make_box(false, 0, false, false, 0)
  label = Gtk::Label.new('end')
  # Pack label into an hbox and pack the hbox into a vbox.
  hbox.pack_end label, false, false, 0
  vbox.pack_end hbox,  false, false, 0
  # Add a Separator:
  separator = Gtk::HSeparator.new
  vbox.pack_start(separator, false, true, 5)
else
  puts "Argument '#{which}' is not an integer from 1 to 3"
end
window.show_all
Gtk.main