#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk2'

N_MENU_ITEMS_TO_CREATE = 10

# =========================================================================== #
# Create a new window:
# =========================================================================== #
window = Gtk::Window.new( Gtk::Window::TOPLEVEL )
window.set_title('Ruby-GTK Menu Test')
window.signal_connect(:delete_event) { Gtk.main_quit }
vbox = Gtk::VBox.new(false, 0)
window.add(vbox)

# =========================================================================== #
# Create the menubar
# =========================================================================== #
menubar = Gtk::MenuBar.new
vbox.pack_start(menubar, false, false, 0)
# =========================================================================== #
# Create our toplevel menuitem.
# =========================================================================== #
top_menu = Gtk::MenuItem.new('Root_Menu')
# =========================================================================== #
# Append top_menu into the menubar
# =========================================================================== #
menubar.append(top_menu)
menubar.append(Gtk::MenuItem.new('Test'))

# =========================================================================== #
# Create an empty menu to hold all of our menuitems
# =========================================================================== #
menu = Gtk::Menu.new
# =========================================================================== #
# Create a few menuitems and append them into "menu"
# =========================================================================== #
(1 .. N_MENU_ITEMS_TO_CREATE).each {|entry|
  item = Gtk::MenuItem.new("MenuItem #{entry}")
  menu.append( item )
}
# =========================================================================== #
# Now we set the submenu of top_menu to our menu holding all of our menuitems
# =========================================================================== #
top_menu.set_submenu(menu)
button = Gtk::Button.new('Press Me')
button.signal_connect(:button_press_event, Gdk::Event::BUTTON_PRESS) {|widget, event, menu|
  puts 'A button was pressed.'
}
vbox.pack_start( button, true, true, 0)
window.set_size_request(800, 600)
window.move(0, 0)
window.show_all
Gtk.main