#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk2'

# =========================================================================== #
# Make a new button type.
# =========================================================================== #
class MyButton < Gtk::Button

  type_register

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(label = nil)
    # When type_register() is used.
    #   super is equivalent to GLib::Object#initialize.
    super(
      {'label' => label }
    )
  end

  # ========================================================================= #
  # === instal_style_property
  # ========================================================================= #
  install_style_property(
    GLib::Param::Int.new(
    'foo', # name
    'Foo', # nick
    'BII', # blurb
        5, # min 
      150, # max
       12, # default
      GLib::Param::READABLE |
      GLib::Param::WRITABLE)
    ) { |pspec, str|
      p pspec, str
      str.to_i + 500 # return the converted value.
    }

  install_style_property(
    GLib::Param::Enum.new(
      'bar', # name
      'Bar', # nick
      'BAR', # blurb
      GLib::Type['GdkCursorType'], # Enum type
      Gdk::Cursor::ARROW, #default
      GLib::Param::READABLE |
      GLib::Param::WRITABLE)
    ) { |pspec, str|
      p pspec, str
      if str.strip! == 'boat'
        Gdk::Cursor::BOAT
      else
        pspec.default
      end
    }
end

if __FILE__ == $PROGRAM_NAME
  Gtk::RC.parse('./060_style_property.rc') # cat style_property.rc
  window = Gtk::Window.new('Gtk::RC sample')
  window.set_size_request(800, 200)
  window.move(0, 0)
  b = MyButton.new('Goodbye')
  b.signal_connect(:clicked) { Gtk.main_quit }
  puts '='*80
  puts 'The style properties are:'
  puts '='*80
  p MyButton.style_properties
  puts '='*80
  window.set_default_size(100, 100)
  window.add(b).show_all
  window.signal_connect(:destroy) { Gtk.main_quit }
  # You need to call them after "Gtk::Widget#show"
  # (Or in expose event).
  p b.style_get_property('foo')
  p cursor = b.style_get_property('bar')
  Gtk.main # $RUBY_GTK/style_property.rb
end