#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# 'css_example.rb'
# =========================================================================== #
require 'gtk3'

class ExamplesWithCSS

  # ========================================================================= #
  # === USE_THIS_AS_THE_CSS_STRING                                  (CSS tag)
  #
  # You can put CSS rules into the following constant, after the EOF part.
  # ========================================================================= #
  USE_THIS_AS_THE_CSS_STRING = <<-EOF

window {
  background-color: whitesmoke; /* replace this here with a colour of your choice; and use 'color' rather than 'colour'*/
}

button {
  background-image: none;
  background-color: yellow;
  border: 3px solid black;
}

/*
 * All buttons respond to this hover CSS style.
 */
button:hover {
  color: royalblue;
  background-color: cyan;
  transition: 4000ms linear;
  border: 3px solid lightgreen;
}

label {
  font-size:  42px;
  font-weight: 800;
  color: steelblue;
}

button:hover label {
  color: blue;
}

button:active {
  background-color: green;
}

button:active label {
  color: white;
}

#yellow_background {
  background: yellow;
}

#lightgreen_background {
  background: lightgreen;
}

#combo_box_text1 {
  border: 10px solid steelblue;
}

check_button {
  -gtk-icon-source: -gtk-scaled(
    url('checkbox-unchecked.jpg'),
    url('checkbox-unchecked@2.jpg')
  );
}

label#foo-bar {
  font: 120px Sans;
}

/*
 * This will make a text-shadow.
 */
#fancy_text_shadow {
  text-shadow:   5px 5px 5px royalblue;
  border-radius: 5px;
  box-shadow:    0px 0px 5px black;
}

image {
  border: 40px solid black;
  border-radius: 50%
}

image:hover {
  transition: 1s linear;
  background-color: #00ff00
}
    
#vbox1 {
  background-image: none;
  padding: 10px;
  border: 3px solid steelblue;
}

#vbox1:hover {
  background-image: none;
  border: 3px solid royalblue;
  background-color: blue;
}

entry:hover {
  background-color: tomato;
}

#transparent1 {
  box-shadow: 0 0 0 5px rgba(0, 20, 0, 0.23), 0 0 25px 50px transparent;
}

frame {
  border: 5px solid #0000ff;
  border-radius: 25px;
  color: #ff0000;
  background-color: #606060;
}

/* Style for a custom Gtk.Box */
#custom_box {
  border: 2px solid #ffffff;
  border-radius: 10px;
  background-color: #000000;
  padding: 0px;
  margin: 10px;
  color: #ffffff;
  opacity: 0.8;
}

/* Style for Gtk.label in Gtk.Box */
box > label {
  color: #00ff00;
  margin: 5px;
}

scale {
  /* top | right | bottom | left */
  margin: 15px;
}

progressbar {
  /* top | right | bottom | left */
  margin: 20px;
}

/* Prograss */
progressbar > trough > progress {
  min-height: 10px;
  background-color: #00ffff;
}

/* Style for Gtk.Paned Separator */
paned > separator {
  background-image: linear-gradient(to bottom, #00ffff, #00ffff);
  background-size: 2px 2px;
}

textview.view {
  margin:  10px;
  padding: 10px;
  border:  2px solid rgba(0, 255, 255, 0.3);
}

grid {
  margin: 10px;
}

grid > label {
  font-size: 12pt;
}

EOF

  alias e puts

  # ========================================================================= #
  # === FILE_HOVER_EFFECTS
  # ========================================================================= #
  FILE_HOVER_EFFECTS =
    '/usr/lib/ruby/site_ruby/3.2.0/gtk_paradise/cascading_style_sheets/'\
    'hover_effects.css'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = 1500

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    reset
    run if run_already
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    @use_this_as_the_css_string = USE_THIS_AS_THE_CSS_STRING.dup
    if File.exist? FILE_HOVER_EFFECTS
      @use_this_as_the_css_string << "\n"
      @use_this_as_the_css_string << File.read(FILE_HOVER_EFFECTS)
    end
    if File.exist? '/home/x/programming/ruby/src/gtk_paradise/lib/gtk_paradise/cascading_style_sheets/project.css'
      @use_this_as_the_css_string << "\n"
      @use_this_as_the_css_string << File.read('/home/x/programming/ruby/src/gtk_paradise/lib/gtk_paradise/cascading_style_sheets/project.css')
    end
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    application = Gtk::Application.new
    application.signal_connect(:activate) {
      # ========================================================================= #
      # We have to pass the CSS into Gtk::CssProvider. We will pass the
      # above-defined constant to this.
      # ========================================================================= #
      provider = Gtk::CssProvider.new
      provider.load(data: @use_this_as_the_css_string)
      Gtk::StyleContext.add_provider_for_screen(
        Gdk::Screen.default,
        provider,
        Gtk::StyleProvider::PRIORITY_APPLICATION
      )
  
      window = Gtk::ApplicationWindow.new(application)
      window.set_size_request(WIDTH, 800)
  
      button_example = Gtk::Button.new(label: 'Button with a hover effect')
      button_example.set_size_request(150, -1)
      button_example.signal_connect(:clicked) { e 'Hello!' }
      button_example.style_context.add_class('clear_background')
      button_example.style_context.add_class('hover_effect_saddlebrown') # Brown colour on hover.
  
      check_button = Gtk::CheckButton.new
  
      entry_example1 = Gtk::Entry.new
      entry_example1.set_name('lightgreen_background')
      entry_example1.set_text('This is entry1.') 
      entry_example1.style_context.add_class('hover_effect_yellow')
      entry_example2 = Gtk::Entry.new
      entry_example2.set_name('yellow_background')
      entry_example2.set_text('This is entry1.')
  
      fixed = Gtk::Fixed.new
      fixed.put(button_example,  50,  10)
      fixed.put(entry_example1, 250, 120)
      fixed.put(entry_example2, 250, 180)
      fixed.put(check_button,   250, 280)
      label_test = Gtk::Label.new('Test!')
      label_test.set_name('foo-bar')
      fixed.put(label_test, 250, 320)
      image = Gtk::Image.new(
        file: '/home/x/programming/ruby/src/'\
              'gtk_paradise/lib/gtk_paradise/images/misc/'\
              'sample_image.png'
      )
      fixed.put(image, 160, 230)
      label1 = Gtk::Label.new('Fancy Text Shadow')
      label1.set_name('fancy_text_shadow')
      fixed.put(label1, 250, 480)
  
      vbox2 = Gtk::Box.new(:vertical)
      vbox2.set_name('vbox2')
      combo_box_text1 = Gtk::ComboBoxText.new
      %w( one two three ).each {|entry|
        combo_box_text1.append_text(entry)
      }
  
      combo_box_text1.set_name('combo_box_text1')
      vbox2.add(combo_box_text1)
      vbox2.set_name('transparent1')
  
      fixed.put(vbox2, 250, 780)
      vbox1 = Gtk::Box.new(:vertical)
      vbox1.set_name('vbox1')
      vbox1.add(Gtk::Label.new('Hey there!'))
      vbox1.set_name('transparent1')
      fixed.put(vbox1, 550, 780)
      frame1 = Gtk::Frame.new
      button3 = Gtk::Button.new(label: "This is button3\nin a frame using CSS")
      button3.signal_connect(:clicked) { e 'button3 was clicked' }
      frame1.add(button3)
      fixed.put(frame1, 880, 750)
      custom_box = Gtk::Box.new(:vertical)
      custom_box.set_name('custom_box')
      custom_box.add(
        Gtk::Label.new('This is #custom_box')
      )
      fixed.put(custom_box, 880, 450)
      text_view = Gtk::TextView.new
      text_view.buffer.set_text(' Hello world!')
      fixed.put(
        text_view, 880, 220
      )
      scrolled_window = Gtk::ScrolledWindow.new
      scrolled_window.add(fixed)
      window << scrolled_window
      window.show_all
      window.move(0, 0)
    }
    application.run
  end

end

if __FILE__ == $PROGRAM_NAME
  ExamplesWithCSS.new  
end