#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk3'

alias e puts

window = Gtk::Window.new('a gtk-entry example')
window.border_width = 15
window.move(0, 0)

box1 = Gtk::Box.new(:vertical, 15)

entry = Gtk::Entry.new
icon_name = 'system-search-symbolic'
entry.set_primary_icon_name(icon_name)

entry.text = 'This is a long example sentence, just '\
             'demonstrating an instance of Gtk::Entry.'
entry.inner_border = Gtk::Border.new(30, 1, 50, 5)
entry.select_region(0, 1)
entry.set_events(Gdk::EventMask::SCROLL_MASK) # Enable scroll-events here.

entry.signal_connect(:scroll_event) {|widget, event|
  puts 'Yes some scrolling happened. '
  _ = event.event_type.name
  case _
  when 'GDK_SCROLL'
    case event.direction
    when Gdk::ScrollDirection::UP   # Scroll-up event.
      e 'We scrolled up!'
    when Gdk::ScrollDirection::DOWN # Scroll-down event.
      e 'We scrolled down!'
    end
  end
}
# To respond to keyboard-key-press events:
# entry.signal_connect(:key_press_event) { |widget, event|
#   _ = Gdk::Keyval.to_name(event.keyval)
#   pp _
# }

e "The parent is: #{entry.parent}" if entry.parent

box1.add(entry)
box1.add(Gtk::Separator.new(:horizontal))

entry2 = Gtk::Entry.new
entry2.set_text('Another example')
icon_name = :system_search_symbolic
entry2.set_icon_from_icon_name(Gtk::EntryIconPosition::PRIMARY, icon_name)
box1.add(entry2)

entry3 = Gtk::Entry.new
entry3.set_text('Showing an icon on the right side')
icon_name = :contact_new
entry3.set_icon_from_icon_name(Gtk::EntryIconPosition::SECONDARY, icon_name)
box1.add(entry3)

# =========================================================================== #
# === do_pulse
# =========================================================================== #
def do_pulse(i, return_value = true)
  i.progress_pulse
  return_value
end

# =========================================================================== #
# Attach a pulse to entry3 next:
# =========================================================================== #
entry3.set_progress_pulse_step(0.2)
_timeout_id = GLib::Timeout.add(500) {
  do_pulse(entry3)
}

button = Gtk::Button.new(label: 'close')
button.signal_connect(:clicked) { Gtk.main_quit }
box1.pack_start(button, expand: false, fill: false, padding: 20)

entry2 = Gtk::Entry.new
entry2.text = 'Test 2'
entry2.set_width_chars(10)
box1.pack_start(entry2, expand: false, fill: false, padding: 20)

entry3 = Gtk::Entry.new
entry3.set_width_chars(10)
# Set a ghost text
entry3.set_placeholder_text('https://youtube.com/watch?v=...')
box1.pack_start(entry3, expand: false, fill: false, padding: 20)

window.add(box1)
window.signal_connect(:destroy) { Gtk.main_quit }
window.show_all.set_size_request(400, 200)
window.move(0, 0)
Gtk.main