#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/button_box_example.rb
# =========================================================================== #
require 'gtk3'

alias e puts

# =========================================================================== #
# === ARRAY_TEXT_FOR_THE_BUTTONS
# =========================================================================== #
ARRAY_TEXT_FOR_THE_BUTTONS = 
%w(
  OK
  Cancel
  Help
)

USE_THIS_AS_THE_CSS_STRING = <<-EOF
#bblack3 {
  border: 3px solid black;
}
EOF

app = Gtk::Application.new('org.gtk.button_box_example')
app.signal_connect(:activate) { |application|
  provider = Gtk::CssProvider.new
  provider.load(data: USE_THIS_AS_THE_CSS_STRING)
  Gtk::StyleContext.add_provider_for_screen(
    Gdk::Screen.default,
    provider,
    Gtk::StyleProvider::PRIORITY_APPLICATION
  )
  window = Gtk::ApplicationWindow.new(application)
  window.set_title('Window')
  window.set_border_width(10)
  window.set_size_request(800, 600)
  # orientation = :horizontal # or
  orientation = :vertical
  button_box = Gtk::ButtonBox.new(orientation)
  # button_box.orientation = :horizontal # If you want to change the orientation.
  button_box.spacing = 12 # Internal spacing to use.
  # ========================================================================= #
  # Next we determine the layout. Valid values include:
  #
  #   :spread, :edge, :start, :center, :expand
  #
  # ========================================================================= #
  button_box.layout = :center # :expand
  ARRAY_TEXT_FOR_THE_BUTTONS.each { |name|
    name = name.dup if name.frozen?
    name.prepend('_') unless name.start_with?('_')
    button = Gtk::Button.new(
      label:         name,
      use_underline: true
    )
    button.set_name('bblack2')
    button.signal_connect(:clicked) {|widget|
      e "Hello world from #{name}"
      # Change the orientation of the button box here:
      case rand(10)
      when 0 .. 5
        button_box.orientation = :horizontal # This is just demo-code really.
      else
        button_box.orientation = :vertical # This is just demo-code really.
      end
    }
    button_box.add(button)
  }
  vbox = Gtk::Box.new(:vertical)
  vbox.pack_start(
    Gtk::Label.new(
      "Click on a button below to change to :horizontal layout/orientation.\n\n"+
      "The initial orientation is :center.\n"
    ),
    padding: 20
  )
  vbox.add(button_box)
  window.add(vbox)
  window.move(0, 0)
  window.signal_connect(:delete_event) { Gtk.main_quit }
  window.show_all
}
app.run