#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/combo_box_example.rb
# =========================================================================== #
require 'gtk3'

alias e puts

window = Gtk::Window.new

combo_box1 = Gtk::ComboBoxText.new

# =========================================================================== #
# === FROZEN_STRING_CONSTANT
#
# Should be frozen.
# =========================================================================== #
FROZEN_STRING_CONSTANT = 'ABC'

# =========================================================================== #
# === ARRAY_FOR_COMBO_BOX1
# =========================================================================== #
ARRAY_FOR_COMBO_BOX1 = %w(
  combo_box_entry1
  combo_box_entry2
  combo_box_entry3
  combo_box_entry4
  combo_box_entry5
  combo_box_entry6
  combo_box_entry7
  combo_box_entry8
)

# =========================================================================== #
# 3000 additions to a combo box cause a delay already. We can toggle that
# number to lower or higher values, and see whether this makes any
# difference.
# =========================================================================== #
N_TIMES = 250 # 2_500
N_TIMES.times {
  ARRAY_FOR_COMBO_BOX1 << FROZEN_STRING_CONSTANT
}

# =========================================================================== #
# Add to combo_box1:
# =========================================================================== #
ARRAY_FOR_COMBO_BOX1.each { |entry| 
  combo_box1.append_text(entry)
}
combo_box1.active = 3
vbox = Gtk::Box.new(:vertical)
vbox.add(Gtk::Label.new('Showing '+N_TIMES.to_s+' entries next'))
vbox.add(combo_box1)

@combo_box2 = Gtk::ComboBoxText.new
@combo_box2.wrap_width = 5 # This means to pad 5 entries per row.
%w( one two three four five six ).each { |val| 
  @combo_box2.append_text(val) 
}
@combo_box2.active = 4 # This selects the entry "five".
@combo_box2.signal_connect(:changed) {
  if @combo_box2.active_iter
    e "#{@combo_box2.active}: #{@combo_box2.active_iter[0]}"
  end
}
@proc_for_combo_box2 = proc {
  @combo_box2.active_text
}
# =========================================================================== #
# === return_the_current_text_of_combo_box_2
# =========================================================================== #
def return_the_current_text_of_combo_box_2(i = @proc_for_combo_box2)
  return i.call
end
@combo_box2.set_tooltip_markup(return_the_current_text_of_combo_box_2)
vbox.add(@combo_box2)

window.add(vbox)
window.show_all
window.move(0, 0)
window.set_size_request(800, 800)
window.signal_connect(:destroy) { Gtk.main_quit }
Gtk.main