#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/accel_group_example.rb
# =========================================================================== #
require 'gtk3'

window = Gtk::Window.new
@accel_group = Gtk::AccelGroup.new
window.add_accel_group(@accel_group)
@entry = Gtk::Entry.new
# =========================================================================== #
# Enable alt+w combination next:
# =========================================================================== #
@accel_group.connect(Gdk::Keyval::KEY_W, :mod1_mask, :visible) { # CONTROL_MASK ist strg
  puts 'They alt+w combination was pressed.'
  @entry.set_text('The key was pressed')
}
box = Gtk::Box.new(:horizontal)
box.add(Gtk::Label.new('Press alt+w key combination '))
box.add(@entry)
window.add(box)
window.show_all
window.set_size_request(600, 50)
window.move(0, 0)
window.signal_connect(:delete_event) { Gtk.main_quit }
Gtk.main