#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/colour_choose_button.rb
# =========================================================================== #
require 'gtk3'

# =========================================================================== #
# Use a larger font, for demonstration purposes.
# =========================================================================== #
::Gtk::Settings.default.gtk_font_name = 'Mono 22'

window = Gtk::Window.new
window.set_size_request(600, 200)

# =========================================================================== #
# === @entry_this_colour_is_in_use
# =========================================================================== #
@entry_this_colour_is_in_use = Gtk::Entry.new

@this_colour_is_in_use = nil
# =========================================================================== #
# Add the choose-colour button next.
# =========================================================================== #
button = Gtk::ColorButton.new
button.set_title('Select a Colour!')
button.signal_connect(:color_set) {
  @this_colour_is_in_use = button.color.to_s
  puts @this_colour_is_in_use
  @entry_this_colour_is_in_use.set_text(@this_colour_is_in_use)
}

button.color = '#616135358383' # Use a starting-colour.
button.set_size_request(500, 220)

label = Gtk::Label.new(
  "← Look then click at the colour box to the left. \\o/"
)

hbox = Gtk::Box.new(:horizontal, 0)
hbox.pack_start(button, expand: false, fill: false, padding: 15)
hbox.pack_start(label,  expand: false, fill: false, padding: 15)

outer_vbox = Gtk::Box.new(:vertical, 0)
outer_vbox.add(hbox)
outer_vbox.add(@entry_this_colour_is_in_use)
window.add(outer_vbox)
window.show_all
window.signal_connect(:destroy) { Gtk.main_quit }
window.move(0, 0)
Gtk.main