#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This file demonstrates how to use Gtk::Listview, for ruby-gtk3.
# =========================================================================== #
# require 'tree_view_column_example.rb'
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/064_tree_view_column_example.rb
# =========================================================================== #
require 'gtk3'

alias e puts

window = Gtk::Window.new
window.border_width = 0
box1 = Gtk::Box.new(:vertical, 0)
window.add(box1)
box2 = Gtk::Box.new(:vertical, 10)
box2.border_width = 10
box1.pack_start(box2, expand: true, fill: true, padding: 0)
scrolled_window = Gtk::ScrolledWindow.new
scrolled_window.set_policy(:automatic, :automatic)
box2.pack_start(scrolled_window, expand: true, fill: true, padding: 0)

dataset = %w(
  hello world
  blah foo
  bar argh
  spencer is 
  a wussy
  programmer
)

list_store = Gtk::ListStore.new(String)

renderer = Gtk::CellRendererText.new
renderer.foreground = :darkgreen
renderer.background = :lightgreen
renderer.xalign = 0.5 # For center-aligned display.

column = Gtk::TreeViewColumn.new('Data', renderer, { text: 0} )
treeview = Gtk::TreeView.new(list_store)
treeview.append_column(column)
treeview.selection.set_mode(:single)

treeview.signal_connect(:button_press_event) { |widget, event|
  case event.button
  when 1
    if event.event_type == Gdk::EventType::BUTTON2_PRESS
      e 'Even a double-click event!'
    else
      e 'The left mouse-button was clicked.'
      e 'The selection was: '+widget.selection.selected[0].to_s
    end
  when 2
    e 'The middle mouse-button was clicked.'
  when 3
    e 'The right mouse-button was clicked.'
  end
}

scrolled_window.add_with_viewport(treeview)
dataset.each { |entry|
  iter = list_store.append
  iter[0] =  entry
}
# Create the add-button next
button = Gtk::Button.new(label: 'add')
i = 0
button.signal_connect(:clicked) {
  # This is the action for the add-button.
  iter = list_store.append
  iter[0] = "add item #{i}"
  i += 1
}
box2.pack_start(button, expand: false, fill: true, padding: 0)
button = Gtk::Button.new(stock: :remove, label: 'remove')
button.signal_connect(:clicked) {
  iter = treeview.selection.selected
  # Remove the iter next.
  list_store.remove(iter) if iter
}
box2.pack_start(button, expand: false, fill: true, padding: 0)
separator = Gtk::Separator.new(:horizontal)
box1.pack_start(separator, expand: false, fill: true, padding: 0)
separator.show
box2 = Gtk::Box.new(:vertical, 10)
box2.border_width = 10
box1.pack_start(box2, expand: false, fill: true, padding: 0)
button = Gtk::Button.new(stock: :close)
button.signal_connect(:clicked) { Gtk.main_quit }
box2.pack_start(button, expand: true, fill: true, padding: 0)
window.set_default_size(500, 500)
window.move(0, 0)
window.signal_connect(:delete_event) { Gtk.main_quit }
window.show_all
Gtk.main # rb tree_view_column_example.rb