#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk3'

class MessageDialogExample < Gtk::Window

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super
    set_title('Message Dialog Example')
    set_border_width(10)
    set_default_size(300, 250)

    box = Gtk::Box.new(:horizontal)
    box.spacing = 6

    button_information = Gtk::Button.new(label: 'Information')
    button_information.signal_connect(:clicked) {
      on_info_clicked
    }
    box.add(button_information)

    # The error button:
    button_information = Gtk::Button.new(label: 'Error')
    button_information.signal_connect(:clicked) {
      on_info_clicked
    }

    box.add(button_information)

    button_special = Gtk::Button.new(label: 'Special widget')
    button_special.signal_connect(:clicked) {
      open_special_widget
    }
    box.add(button_special)
    add(box)
    signal_connect(:destroy) { Gtk.main_quit }
    show_all
  end

  # ========================================================================= #
  # === on_info_clicked
  # ========================================================================= #
  def on_info_clicked
    message_dialog = Gtk::MessageDialog.new(
      parent: toplevel, 
      flags: [:modal, :destroy_with_parent],
      type: :info,
      buttons: :ok,
      message: 'A message dialog.'
    )
    message_dialog.secondary_text = 'This is secondary text to appear.'
    message_dialog.set_size_request(680, 500)
    message_dialog.show_all
    message_dialog.signal_connect(:response) { message_dialog.destroy }
    message_dialog.run
  end

  # ========================================================================= #
  # === open_special_widget
  # ========================================================================= #
  def open_special_widget
    require 'gtk_paradise/widgets/gtk3/editor/internal_widgets/goto_line_widget.rb'
    message_dialog = Gtk::MessageDialog.new(
      parent: toplevel, 
      flags: [:modal, :destroy_with_parent],
      type: :info,
      buttons: :ok,
      message: 'A message dialog.'
    )
    message_dialog.secondary_text = 'This is secondary text to appear.'
    message_dialog.set_size_request(680, 500)
    message_dialog.show_all
    message_dialog.signal_connect(:response) { message_dialog.destroy }
    message_dialog.add_child(Gtk::GotoLineWidget.new)
    message_dialog.run
  end

end

if __FILE__ == $PROGRAM_NAME
  win = MessageDialogExample.new
  win.show_all
  win.move(0, 0)
  Gtk.main  
end


__END__
# This was the python base

class MessageDialogWindow(Gtk.Window):

    button3 = Gtk.Button(label="Warning")
    button3.connect("clicked", self.on_warn_clicked)
    box.add(button3)

    button4 = Gtk.Button(label="Question")
    button4.connect("clicked", self.on_question_clicked)
    box.add(button4)

  def on_info_clicked(self, widget):
    dialog = Gtk.MessageDialog(
      transient_for=self,
      flags=0,
      message_type=Gtk.MessageType.INFO,
      buttons=Gtk.ButtonsType.OK,
      text="This is an INFO MessageDialog",
    )
    dialog.format_secondary_text(
      "And this is the secondary text that explains things."
    )
    dialog.run()
    print("INFO dialog closed")
    dialog.destroy()

  def on_error_clicked(self, widget):
    dialog = Gtk.MessageDialog(
      transient_for=self,
      flags=0,
      message_type=Gtk.MessageType.ERROR,
      buttons=Gtk.ButtonsType.CANCEL,
      text="This is an ERROR MessageDialog",
    )
    dialog.format_secondary_text(
      "And this is the secondary text that explains things."
    )
    dialog.run()
    print("ERROR dialog closed")

    dialog.destroy()

  def on_warn_clicked(self, widget):
    dialog = Gtk.MessageDialog(
      transient_for=self,
      flags=0,
      message_type=Gtk.MessageType.WARNING,
      buttons=Gtk.ButtonsType.OK_CANCEL,
      text="This is an WARNING MessageDialog",
    )
    dialog.format_secondary_text(
      "And this is the secondary text that explains things."
    )
    response = dialog.run()
    if response == Gtk.ResponseType.OK:
      print("WARN dialog closed by clicking OK button")
    elif response == Gtk.ResponseType.CANCEL:
      print("WARN dialog closed by clicking CANCEL button")

    dialog.destroy()

  def on_question_clicked(self, widget):
    dialog = Gtk.MessageDialog(
      transient_for=self,
      flags=0,
      message_type=Gtk.MessageType.QUESTION,
      buttons=Gtk.ButtonsType.YES_NO,
      text="This is an QUESTION MessageDialog",
    )
    dialog.format_secondary_text(
      "And this is the secondary text that explains things."
    )
    response = dialog.run()
    if response == Gtk.ResponseType.YES:
      print("QUESTION dialog closed by clicking YES button")
    elif response == Gtk.ResponseType.NO:
      print("QUESTION dialog closed by clicking NO button")

    dialog.destroy()

win = MessageDialogWindow()
win.connect("destroy", Gtk.main_quit)
win.show_all()
