#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::SwitcherWindow
# =========================================================================== #
# This example only works on ruby-gtk3, as Gtk::Switch is not part of gtk2.
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/014_switcher_window.rb
# =========================================================================== #
require 'gtk3'

module Gtk

class SwitcherWindow < ::Gtk::Box

  alias e puts

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Switch Demo'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super(:horizontal)
    set_border_width(16)
    run
  end

  # ========================================================================= #
  # === on_switch_activated
  # ========================================================================= #
  def on_switch_activated(switch)
    state = switch.active? ? 'on' : 'off'
    e "Switch was turned #{state}"
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    grid = ::Gtk::Grid.new
    grid.set_column_spacing(6)
    grid.set_row_spacing 6
    add(grid)

    4.times { |i|
      2.times { |j|
        switch = ::Gtk::Switch.new
        switch.signal_connect('notify::active') { |entry|
          on_switch_activated(entry)
        }
        switch.set_active [true, false].sample
        grid.attach(switch, i, j, 1, 1)
      }
    }
  end

end; end

if __FILE__ == $PROGRAM_NAME
  switcher_window = Gtk::SwitcherWindow.new
  window = Gtk::Window.new
  window.set_title(Gtk::SwitcherWindow::TITLE)
  window.add(switcher_window)
  window.signal_connect(:destroy) { Gtk.main_quit }
  window.set_size_request(250, 100)
  window.show_all
  window.move(0, 0)
  Gtk.main  
end