#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This shows how to use threads in gtk3.
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/threads_example.rb
# =========================================================================== #
require 'gtk3'

alias e puts

N_TIMES = 500_000

button = Gtk::Button.new(label: 'I am freezing!')
button.signal_connect(:clicked) {
  Thread.new {
    k = 0
    N_TIMES.times {
      k += 1
      e k
      if (k % 10000).zero?
        label = "I'm freezing: #{k}"
        GLib::Idle.add {
          button.label = label
          GLib::Source::REMOVE
        }
      end
    }
  }
}

window = Gtk::Window.new
window.set_size_request(500, 500)
window.move(0, 0) # This positions the window to the top-left corner.
window.signal_connect(:destroy) {
  e 'The destroy-event has occurred.'
  Gtk.main_quit
}

window.border_width = 10
window.add(button)
window.show_all
Gtk.main