#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This simply shows ten gtk-label entries in a vertical box. The alignment
# will be onto the center, which is the default for a vertical box.
# =========================================================================== #
# $GTK_PARADISE/examples/gtk3/ten_labels_in_a_vertical_box_example.rb
# =========================================================================== #
require 'gtk3'

::Gtk::Settings.default.gtk_font_name = 'Sans 22'

w = Gtk::Window.new
vbox = Gtk::Box.new(:vertical)

vbox.add(Gtk::Label.new('1'))
vbox.add(Gtk::Label.new('2'))
vbox.add(Gtk::Label.new('3'))
vbox.add(Gtk::Label.new('4'))
vbox.add(Gtk::Label.new('5'))
vbox.add(Gtk::Label.new('6'))
vbox.add(Gtk::Label.new('7'))
vbox.add(Gtk::Label.new('8'))
vbox.add(Gtk::Label.new('9'))
vbox.add(Gtk::Label.new('10'))
vbox.show_all
w.add(vbox)
w.show_all
w.set_size_request(820, 380)
w.move(0, 0)
w.signal_connect(:destroy) { Gtk.main_quit }
Gtk.main