#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk3'

alias e puts

# =========================================================================== #
# === handle_on_click_action
# =========================================================================== #
def handle_on_click_action(box, event)
  e "x position: #{event.x.round(0)}, "\
    "y position: #{event.y.round(0)}"
end

window = Gtk::Window.new

icon_theme = Gtk::IconTheme.default
icon = icon_theme.load_icon('window-close', 32, 0) # Use the window-close example.
image = Gtk::Image.new(pixbuf: icon) # Use the icon here.
event_box = Gtk::EventBox.new
event_box.add_events(Gdk::EventMask::POINTER_MOTION_MASK)
event_box.add(image)
event_box.set_size_request(32, 32)
event_box.signal_connect(:button_press_event) {|widget, event|
  handle_on_click_action(widget, event)
}
# event_box.signal_connect(:motion_notify_event) { e 'The mouse was moved.' }
event_box.signal_connect(:enter_notify_event) {
  e 'mouse-enter-event'
}
event_box.signal_connect(:leave_notify_event) {
  e 'mouse-leave-event'
}
    
window.add(event_box)
window.set_size_request(800, 600)
window.show_all
window.move(0, 0)
window.title = 'This widget will print where the click-action occurred.'
window.signal_connect(:delete_event) { Gtk.main_quit }
Gtk.main